// ORBS by johnowhitaker
//https://www.shadertoy.com/view/styXD1
// Licence CC0
// Adapted, trivialy, for use in VGHD player
uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.
uniform sampler2D iChannel0;

#define iResolution u_WindowSize
#define iTime          u_Elapsed*0.314159265
#define PI            3.141592654
#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_PRESS))*u_WindowSize/3.14159265)
#define MOUSE_PRESS vec2(0.0,1.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define mouse vec4(0.0,1.0, 0.0,0.0)

const float pi = 3.14159;

void main( void )
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    
    uv = uv / (iMouse.xy/iResolution.xy + 0.5);
    
    vec2 z = vec2(iMouse.x/iResolution.x + cos(iTime/2.)*0.2 , iMouse.y/iResolution.y + sin(iTime/2.)*0.2);
    
    // FROM NB
    vec4 f0_0=sin(uv.x*vec4(-8.304,14.23,-13.09,-3.516)+uv.y*vec4(-2.308,10.16,7.632,-.2714)+z.x*vec4(10.06,2.565,-3.345,-10.92)+z.y*vec4(-4.81,-5.927,-15.43,2.175)+vec4(-29.04,-28.82,25.91,2.542));
    vec4 f0_1=sin(uv.x*vec4(.7215,-9.012,12.6,8.861)+uv.y*vec4(13.73,-10.98,.5196,-.938)+z.x*vec4(11.04,-9.148,12.14,-13.62)+z.y*vec4(-3.644,5.796,-13.48,-7.047)+vec4(10.89,18.49,-25.87,25.94));
    vec4 f0_2=sin(uv.x*vec4(-8.808,-13.05,13.67,-.9131)+uv.y*vec4(7.848,-3.638,1.796,-12.69)+z.x*vec4(-11.81,14.11,-9.941,-12.64)+z.y*vec4(-12.51,-1.512,-7.067,8.392)+vec4(-24.69,-27.37,-14.89,-24.45));
    vec4 f0_3=sin(uv.x*vec4(-13.22,7.364,13.77,-11.22)+uv.y*vec4(9.838,8.37,3.302,-8.957)+z.x*vec4(-7.157,3.664,-6.343,2.283)+z.y*vec4(8.621,-12.46,-7.881,-2.434)+vec4(-27.37,18.39,2.747,-18.44));
    vec4 f1_0=sin(mat4(-.1835,.01204,-.1352,.08023,-.16,.09084,-.2363,-.02799,.5707,-.5113,-.1981,.3307,.1543,.04107,.2926,.2279)*f0_0+
        mat4(.08225,-.09573,-.2785,.2704,-.3698,.1969,.1334,-.3363,.1591,.1787,-.2024,-.732,-.2663,.3281,.1447,-.5129)*f0_1+
        mat4(-.4637,.9246,.6259,-1.227,.02322,.05279,.08694,.1819,-.2862,.02528,.4075,.04618,.5716,-.9036,.3876,-1.343)*f0_2+
        mat4(-.2624,.4931,.332,-.4639,-.2945,.1728,.1832,-.4565,-.8835,.2774,.3162,-.3551,.2852,.07586,-.1712,-.01276)*f0_3+
        vec4(11.68,10.81,-13.5,6.794));
    vec4 f1_1=sin(mat4(-.09669,.46,-.0406,.3481,-.1256,-.03705,-.1782,.232,.08453,-.03953,.1027,.02372,.286,-.06678,.08333,-.3805)*f0_0+
        mat4(.1273,-.06173,.1559,-.007184,-.2613,-.6627,.1151,-.02854,.2821,-.621,.3886,-.6447,-.1288,-.1857,.07629,.1559)*f0_1+
        mat4(.8466,-.8261,-.3861,-.3738,-.1109,.3325,-.09278,.1451,.1303,.07398,.1861,.5223,-.7469,.8747,-.2076,-.3255)*f0_2+
        mat4(.5034,-.09621,.02708,.259,-.193,-.3275,-.1347,.05682,-.4378,-.02457,-.06228,.2946,.4467,-.06423,-.6044,-.3572)*f0_3+
        vec4(-2.639,8.012,7.74,-9.521));
    vec4 f1_2=sin(mat4(.2273,.00841,.1723,.3967,.08702,.1004,-.26,-.3182,-.09158,.2024,-.8704,-.2552,-.2932,-.1954,.4663,-.1283)*f0_0+
        mat4(-.03901,-.3595,-.1401,.5891,-.09322,.1146,.09341,-.1005,-.3933,.5743,-.6506,-1.14,-.1919,-.05167,-.05656,-.07762)*f0_1+
        mat4(-.3706,-.2416,.04861,.3101,.165,-.3046,.03562,.1609,-.09553,.2279,.1812,-.5852,.7445,.3991,-.4199,.04403)*f0_2+
        mat4(-.08418,.1001,.5559,-.1791,-.007894,.1006,.2935,.06869,.2253,.284,.4847,-.4962,-.06824,-.2816,-.7816,-.2907)*f0_3+
        vec4(6.153,10.24,-5.958,-7.625));
    vec4 f1_3=sin(mat4(.379,-.09784,-.1073,-.08592,.1485,.1718,.1288,.1838,.05212,-.3788,-.5063,.5767,.2115,-.06351,-.159,-.1653)*f0_0+
        mat4(.4283,.1504,-.2163,.03603,-.0542,.4352,.188,-.3596,.5418,-.2349,.4088,-.1765,.2288,.05744,.2326,-.43)*f0_1+
        mat4(-.1491,.9542,.7029,-.6157,.0854,-.01757,.2198,.05495,-.5279,.3269,-.256,.1722,.5688,-1.044,-.5885,.7955)*f0_2+
        mat4(.1264,.5187,.3495,-.584,-.03029,.2662,-.0002758,-.2504,.05953,.2617,.1693,-.464,-.1073,-.194,.0751,.1949)*f0_3+
        vec4(-15.02,-7.793,7.188,-4.352));
    vec4 f2_0=sin(mat4(.3039,.06638,-.0977,-.5329,.5464,-.06746,-.1871,-.3097,-.2815,-.08951,-.4071,.428,.4813,.4597,.05119,-.6545)*f1_0+
        mat4(.002844,.2924,.3606,-.4938,-.296,.6933,-.3041,.2644,.2611,.4607,.251,-.367,-.04104,.3854,-.3636,.09104)*f1_1+
        mat4(.6126,-.1668,.1123,.02365,-.2715,-.2932,-.288,.3034,-.2086,-.08185,.03178,.5133,-.3355,-.1805,.2201,.1963)*f1_2+
        mat4(-.5728,.08837,-.0881,.5391,.5985,-.06755,-.3042,-.8863,-.6227,.4658,-.6119,.863,-1.03,.0696,-.1544,1.336)*f1_3+
        vec4(-1.162,-3.009,-4.006,-11.7));
    vec4 f2_1=sin(mat4(-.1049,-.2732,-.06487,-.0882,.1385,-.4216,.04616,.2917,.02393,.2148,-.01563,-.2266,-.1713,-.1453,.3172,.3506)*f1_0+
        mat4(-.07317,-.109,.712,.1132,-.04253,.1359,-.3805,-.4749,.1283,-.2085,-.6047,.1948,.1046,.007434,-.2491,.0873)*f1_1+
        mat4(.3098,-.1641,.3933,-.06219,-.2683,.1758,.3489,-.3786,.1478,.3022,.1989,-.07118,.1408,-.04302,-.1363,.2096)*f1_2+
        mat4(-.1195,.4016,.1338,-.1518,-.2194,-.4984,-.1873,.07262,-.3544,.3185,-.794,-.5803,.3585,.4723,-.3592,-.6277)*f1_3+
        vec4(7.626,-.05849,5.741,2.143));
    vec4 f2_2=sin(mat4(-.1156,.3524,.2532,.6886,.2113,.6314,.5381,.984,-.318,.4587,-.1975,-.349,-.1431,.09714,-.0222,.2476)*f1_0+
        mat4(-.3027,.1713,.0656,.02209,.4845,-.6145,-.4192,-.08574,.03365,-.5932,-.1836,.3461,-.234,.2229,-.0004068,.1412)*f1_1+
        mat4(.1454,.33,-.008351,.4654,-.09636,-.006581,-.3192,-.3018,-.1888,-.2273,-.3709,-.6797,-.2075,.01434,.1363,-.05041)*f1_2+
        mat4(-.2805,.359,-.126,-.5668,.02739,.381,.215,1.397,-.1682,-.5935,-.2975,-.9776,.199,-.604,-.1413,-.9927)*f1_3+
        vec4(-8.173,-5.341,11.05,-13.82));
    vec4 f2_3=sin(mat4(-.1773,-.0008406,-.3234,-.2071,.06475,-.4094,-.294,-.0156,-.258,-.1924,.07022,.4462,-.06016,-.4306,.3581,-.1742)*f1_0+
        mat4(.0645,-.09507,.5453,.0971,.1479,.123,.2024,-.2002,.3001,.3737,-.2042,-.518,-.05481,-.03801,-.4284,-.5023)*f1_1+
        mat4(.2754,-.3257,.3985,.3698,.0502,.1845,.3971,.3549,.06821,-.0961,.3485,-.09577,-.1212,.5444,-.3126,.2299)*f1_2+
        mat4(-.1798,-.3132,-.2156,.1593,-.2016,-.1713,-.3529,-.1618,.1073,.2379,-.05476,-.1114,-.3443,-.3661,.1518,-.3582)*f1_3+
        vec4(-2.263,12.14,-2.813,-11.19));
    vec4 f3_0=sin(mat4(-1.072,-.2771,-.3836,.1524,-.1683,-.2484,.1148,.01516,.5321,-.4219,-.4656,.4778,1.187,.2954,-.3458,.3384)*f2_0+
        mat4(-.1324,.3976,.2759,.001008,.5622,.124,.1786,.192,-.7785,-.2429,-.281,-.3922,.3976,.505,.2629,.1377)*f2_1+
        mat4(.2839,-.03703,.1368,.5448,-.7792,-.03523,.001305,-.4438,-.4777,-.3366,.2683,.1103,-.4744,.1815,-.00598,.4887)*f2_2+
        mat4(-.2187,.02974,.267,.1346,-.2397,-.09903,-.3867,.02329,-.09057,-.686,.3695,.5945,-.2297,.3801,.4419,-.2295)*f2_3+
        vec4(-2.459,-10.89,-10.48,11.12));
    vec4 f3_1=sin(mat4(-.7457,-.2821,-.1584,.4261,-.5452,-.4999,.2139,.0835,.4624,.5348,.02566,-.1119,1.129,-.2908,-.2343,-.1789)*f2_0+
        mat4(.5495,.2054,.02039,.1763,.8699,-.3326,-.0297,-.6744,-.2274,-.2966,.0107,-.1593,.4901,.6892,-.1415,.05604)*f2_1+
        mat4(-.5897,-.6353,.1121,-.06588,-.6456,-.2196,.3971,.4399,.4594,-.5289,-.08876,-.1969,-.8084,.4232,.3489,.3158)*f2_2+
        mat4(.1491,-.2415,-.4945,.4498,.07797,.2048,.1459,-.2167,.1275,.256,-.09348,.04826,.1156,.2649,-.03068,-.1868)*f2_3+
        vec4(5.909,14.68,-14.57,-6.614));
    vec4 f3_2=sin(mat4(.4776,-.2546,.01251,.8376,.31,-.3185,-.1023,.08683,-.2457,-.1518,-.1998,.08988,-1.261,.07595,.1674,-1.048)*f2_0+
        mat4(.09664,-.02019,-.2221,.07324,-.5236,.419,.4981,-.1208,-.1935,.3763,-.5442,.5659,.04217,.3884,.3224,-.4306)*f2_1+
        mat4(.4123,-.02622,.5415,-.06706,.7748,-.3367,-.0625,.03979,-.0817,.1996,.524,.1134,.7683,-.3113,-.6603,.8432)*f2_2+
        mat4(.4311,-.3632,-.3286,.5831,.2195,-.2306,.1796,.2963,.2422,.07635,.06853,-.2024,-.3508,-.06383,.1661,.2875)*f2_3+
        vec4(5.185,.4785,1.86,7.639));
    vec4 f3_3=sin(mat4(-.117,-.4953,.1445,.4162,-.2075,-.1281,-.05272,-.2415,-.4722,.07495,.4423,-.1223,1.129,.8229,-.9723,-.1303)*f2_0+
        mat4(.21,.2103,-.3154,-.4798,-.327,.4047,.06655,-.5408,-.004849,.2473,-.6357,.3587,.1072,.2806,.1453,.1685)*f2_1+
        mat4(-.437,-.4492,.2836,.3485,.02207,-.3213,-.1294,-.1072,.1905,.1253,.5814,.3559,-1.087,-.1211,-.3736,.5429)*f2_2+
        mat4(-.5582,.513,-.2771,.1839,-.4183,.04213,-.06996,.01943,-.1174,-.4641,-.09937,-.01392,.1908,.05119,-.3076,.01316)*f2_3+
        vec4(8.713,3.933,-1.085,2.8));
    vec4 f4_0=sin(mat4(1.036,.6157,-.5171,-.3075,.9704,.05874,-.1379,.301,.1001,-.2606,-.2812,-.2246,.2399,.7854,.6273,-.2678)*f3_0+
        mat4(-.6646,.6227,.4167,.6873,.5899,.6374,-.02355,-.31,-.4065,-.3212,.6476,.311,.7652,.8759,.3396,.4235)*f3_1+
        mat4(-.04224,-.05212,.5501,.4613,.1406,-.5038,-.7832,.3707,.2331,-.5108,-.6779,-.2553,.5033,.09403,-.108,-.5577)*f3_2+
        mat4(-.04242,.1373,.2314,.6772,.6604,.5087,.4411,.1803,-.3069,-.4461,-.2466,-.4575,-.06976,-.1003,-.7084,-.2113)*f3_3+
        vec4(-5.476,-5.603,-3.958,11));
    vec4 f4_1=sin(mat4(.167,.1901,.2602,.1328,-.03457,.3292,-.07235,-.3316,-.002219,-.1285,.2396,-.1699,.2913,-.09743,.3015,.03005)*f3_0+
        mat4(-.7463,-.02697,-.5854,-.1541,.4203,.1063,.4058,-.05652,-.607,-.002699,.1979,.5238,-.2732,-.1056,.04514,.2102)*f3_1+
        mat4(-.7106,.3198,-.543,.4577,.06245,-.352,.6366,-.6735,-.0891,-.1531,.2705,-.2174,.4332,-.1868,.6018,.09878)*f3_2+
        mat4(-.4832,.8868,-.6595,.6112,-.4326,.3538,-.4557,.207,.004831,.08989,-.01086,.622,.116,.1336,-.2469,-.4734)*f3_3+
        vec4(-5.227,-3.394,4.494,10.26));
    vec4 f4_2=sin(mat4(.3484,-.3943,.1312,.1302,-.07036,.4481,.02631,.584,.03691,.8424,-.1278,1.124,.493,-.3749,.005645,-.6828)*f3_0+
        mat4(-.2452,.5948,-.7186,.09257,.5588,-.2886,.5044,-.2611,-.6172,-.4476,-.6037,-1.004,-.2078,.4954,-.2012,-.8777)*f3_1+
        mat4(-.726,.4934,-.8112,-.3511,.5818,.4207,.08468,1.004,.2418,-.409,-.06966,.9689,.4053,-.5707,.4501,-.1101)*f3_2+
        mat4(-.5559,.4929,-.5709,-.2503,-.09328,.2226,-.3038,-.841,.0874,-.08159,-.04659,-.988,.1155,.4964,.4016,.435)*f3_3+
        vec4(7.096,-3.664,13.45,-6.311));
    vec4 f4_3=sin(mat4(.9893,-.3396,1.034,-.7001,.1877,.2791,-.1682,-.09207,-.2863,.2406,-.2766,-.2904,.1897,-.3151,-.5959,.5197)*f3_0+
        mat4(-.652,.5047,-.147,1.04,.1723,-.7124,.178,.222,-.3357,-.1206,-.4422,.0667,.1834,-.05865,.1853,.1964)*f3_1+
        mat4(-.5043,.8521,-.08404,-1.116,-.4662,-.3206,-.1306,-.4875,-.3618,-.4083,-.3823,.138,.4859,-.2519,.6143,.511)*f3_2+
        mat4(.472,.2605,-.2256,-.1061,.2724,.2676,.4117,-.9562,.3362,.1054,-.04584,-.1043,-.02135,-.2942,.1766,-.357)*f3_3+
        vec4(9.124,1.583,-12.99,1.381));
    float r=dot(f4_0,vec4(-.01955,.02902,.002031,.02871))+
        dot(f4_1,vec4(-.03271,-.00788,.0337,-.01857))+
        dot(f4_2,vec4(-.03467,.02526,-.0294,.0002041))+
        dot(f4_3,vec4(-.02249,-.0306,.02342,.0004094))+
        0.506;
    float g=dot(f4_0,vec4(.01888,-.01998,-.02678,.02829))+
        dot(f4_1,vec4(-.02624,.02469,.02121,.01974))+
        dot(f4_2,vec4(-.01574,.02536,-.02586,-.02237))+
        dot(f4_3,vec4(.01991,-.0212,-.01907,.02567))+
        0.551;
    float b=dot(f4_0,vec4(.02944,-.007691,-.006526,.001695))+
        dot(f4_1,vec4(-.002626,-.02395,.005061,-.01643))+
        dot(f4_2,vec4(.002323,-.008691,-.004447,.005888))+
        dot(f4_3,vec4(.02472,.003733,-.02358,-.007015))+
        0.424;
    

    // Time varying pixel color
    vec3 col = vec3(r, g, b);

    // Output to screen
    gl_FragColor = vec4(col,1.0);
}